<?php

class LocalNumberController extends Controller
{
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('getArea','getState','create','update','detail'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	public function actionAdmin()
	{
		$this->render('admin');
	}

	public function actionCreate()
	{
		$this->render('create');
	}

	public function actionIndex()
	{
		// configure cookie to store service type	
		Yii::app()->request->cookies['buy_number[referel_url]'] = new CHttpCookie('buy_number[referel_url]', 'localNumber'); 	
		Yii::app()->request->cookies['buy_number[service_type]'] = new CHttpCookie('buy_number[service_type]', 'Local');
		
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('localmembernumber');
		}else {
			$this->render('localmembernumber');
		}
	}

	public function actionUpdate()
	{
		$this->render('update');
	}

	public function actionView()
	{
		$this->render('view');
	}
	public function actionGetArea()
	{
		$state=$_POST['state'];		
		$data=Area::model()->findAll('state_id=:state_id',array(':state_id'=>(int)$state));
		$data=CHtml::listData($data,'area_id','area_name'); 
	    echo "<option value=''>Select Area</option>";
	    foreach($data as $value=>$area_name)
	    {
	    	echo CHtml::tag('option', array('value'=>$value),CHtml::encode($area_name),true);
	    }
	}
	public function actionGetState()
	{
		 $country_id=$_POST['country_id'];		
		$data=State::model()->findAll('country_id=:country_id',array(':country_id'=>(int)$country_id));
		$data=CHtml::listData($data,'state_id','state_name'); 
	    echo "<option value=''>-Select-</option>";
	    foreach($data as $value=>$state_name)
	    {
	    	echo CHtml::tag('option', array('value'=>$value),CHtml::encode($state_name),true);
	    }
	}


	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}