<?php

class SiteController extends Controller
{
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$this->render('index');
	}

	public function actionShowLogs(){
		$url = Yii::app()->runtimePath.'/application.log';
	
		if(file_exists($url)){
	
			$myfile = fopen($url, 'r');
			while(!feof($myfile)) {
				echo nl2br(fgets($myfile));
			}
			fclose($myfile);
	
		}else{
			echo "<span style='color:green;'>No Recent Logs</span>";
		}
		Yii::app()->end();
	}
	public function actionDeleteAssets()
	{
		$path = Yii::app()->getAssetManager()->basePath;
		self::rrmdir($path);
		$runtime = Yii::app()->runtimePath;
		self::rrmdir($runtime);
		echo "<span style='color:green;'>Deleted ..</span>";
		Yii::app()->end();
	}
	public static function rrmdir($dir, $delete = false)
	{
		if (is_dir($dir)) {
			$objects = scandir($dir);
			foreach ($objects as $object) {
				if ($object != "." && $object != "..") {
					if (filetype($dir . "/" . $object) == "dir") {
						self::rrmdir($dir . "/" . $object, true);
					} else
						if ($object != 'assets') {
	
							if (unlink($dir . "/" . $object))
								echo '<p style="color:red">Removed File : ' . $dir . "/" . $object . '<br /></p>';
						}
				}
			}
			reset($objects);
	
			if ($delete) {
				if (rmdir($dir))
					echo '<p style="color:grey">Removed Directory :' . $dir . '<br /></p>';
			}
		}
	}
	/**
	 * This is the action to handle external exceptions.
	 */
	
	public function actionError()
	{
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}

	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$name='=?UTF-8?B?'.base64_encode($model->name).'?=';
				$subject='=?UTF-8?B?'.base64_encode($model->subject).'?=';
				$headers="From: $name <{$model->email}>\r\n".
					"Reply-To: {$model->email}\r\n".
					"MIME-Version: 1.0\r\n".
					"Content-Type: text/plain; charset=UTF-8";

				mail(Yii::app()->params['adminEmail'],$subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}
	
	public function actionDashboard()
	{
		$userid=Yii::app()->user->getId(); 
		$model=new Dashboard;
		$criteria=new CDbCriteria;
		$datas=Dashboard::model()->find("customerid=$userid");
		
		$criteria = new CDbCriteria;
		$criteria->condition='customerid=:userid AND status=:status';
		$criteria->params=array(':userid'=>$userid,':status'=>1);
		$telephone_number=CustomerNumber::model()->findAll($criteria);				
		
		 $criteria->condition = 'time BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE() AND customerid='.$userid.'';
		 $cdrs = Cdrs::model()->findAll($criteria);
		 if(Yii::app()->request->isAjaxRequest) {
		 	$this->renderPartial('dashboard',array('data'=>$datas,'telephone_number'=>$telephone_number,'cdrs'=>$cdrs));
			
		}else {
			$this->render('dashboard',array('data'=>$datas,'telephone_number'=>$telephone_number,'cdrs'=>$cdrs));
		}
		
		
	} 
		
	public function actionAccount() {
		$userid=Yii::app()->user->getId(); 
        //$model = User::model()->findByPk($userid);
		$model = new User;		
		$model1= new CustomerCreditCard;
        if (isset($_POST['User'])) { 
			
				$condition = 'customerid ='.$userid;
			    $data['firstname'] = $_POST['User']['firstname'];
			    $data['lastname'] = $_POST['User']['lastname'];
				$model->updateAll( $_POST['User'], $condition );
				//refer: http://harrybailey.com/2011/08/yii-updateall-example/
				//http://www.yiiframework.com/doc/guide/1.1/en/database.ar#updating-record
				//http://stackoverflow.com/questions/20746805/how-does-the-update-operation-work-in-yii
				Yii::app()->user->setFlash('sucess','Your account changed successfully.');				
			//}
        }
       // $credit_card_cust_details=CustomerCreditCard::model()->find("customerid=$userid");
       $user_data = InmateUser::model()->find("customerid=$userid"); 
  
       if(!empty($user_data->customer_profile_id)) {
        $creditCardData = CimAccess::getCreditCardData($user_data->customer_profile_id,$user_data->customerPaymentProfileId);
        Yii::log(CVarDumper::DumpAsString($creditCardData),CLogger::LEVEL_WARNING,'card_data');
        if ("Ok" == $creditCardData->messages->resultCode) {
        	$cardData['firstname'] = $creditCardData->paymentProfile->billTo->firstName;
        	$cardData['lastname'] = $creditCardData->paymentProfile->billTo->lastName;
        	$cardData['cardnumber'] = $creditCardData->paymentProfile->payment->creditCard->cardNumber;
        }		
    }else {
    	$cardData = array();
    }
        
		$credit_card_details=CustomerCreditCard::model()->find("customerid=$userid");
		$userdetails = Account::model()->find("customerid=$userid"); 
		$countries = Countries::model()->findAll();
       // $states = State::model()->findAll("country_id=$userdetails->country"); 
		$states = State::model()->findAll();
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('account',array('userdetails'=>$userdetails,'credit_card_details'=>$cardData,'model'=>$model,'model1'=>$model1, 'countries' => $countries, 'states' => $states));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'credit_card_details'=>$cardData,'model'=>$model,'model1'=>$model1, 'countries' => $countries, 'states' => $states));
		}
	}

	
	public function actionSaveCreditCard() {
	
		if(empty($_POST))
			$this->redirect(array('/users/account'));
	
		$userid=Yii::app()->user->getId();
		$user_data = InmateUser::model()->find("customerid=$userid");
		
		$name = explode(" ", $_POST["CustomerCreditCard"]['name_card']);
	
		$fname = $lname = '';
		if(isset($name[0]))
			$fname = $name[0];
	
		if(isset($name[1]))
			$lname = $name[1];
	
		$cardNO = $_POST["CustomerCreditCard"]['cardnumber'];
		$expiryDate =  $_POST["expiry_year"]."-".$_POST["expiry_month"];
		$cvv = $_POST["CustomerCreditCard"]['csv'];
		//$user_data->customer_profile_id = 221623206;
		Yii::log(CVarDumper::DumpAsString($user_data->customer_profile_id),CLogger::LEVEL_WARNING,'profile_id');
		if(!empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId))
		{
			CimAccess::authNetDeleteProfile($user_data->customer_profile_id);
			$user_data->customer_profile_id = '';
			$user_data->saveAttributes(array('customer_profile_id'));
		}
		if(empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId)) { // save credit card data.
			$user_email = $user_data->email;
			$pno = $user_data->MobileNumber;
			$address = $user_data->address;
			$city = $user_data->city;
			$state = $user_data->state;
			$zip = $user_data->zip;
	
			$creditCardData = CimAccess::saveCreditCard("IU".$userid,$user_email,$address,$city,$state,$zip,$cardNO,$expiryDate,$cvv,$fname,$lname,$pno);
			Yii::log(CVarDumper::DumpAsString($creditCardData),CLogger::LEVEL_WARNING,'$creditCardData');
			
			if(!empty($creditCardData)) {
				
				$command = Yii::app()->db->createCommand();
				$command->update('inmate_customers', array(
						'customer_profile_id'=>$creditCardData['profileId'],
						'customerPaymentProfileId'=>$creditCardData['paymentProfileId'],
						'customerAddressId'=>$creditCardData['shippingId']
				), 'customerid=:id', array(':id'=>$userid));
				
			}
	
		}else {
			$pno = $user_data->MobileNumber;
			$address = $user_data->address;
			$city = $user_data->city;
			$state = $user_data->state;
			$zip = $user_data->zip;
			$creditCardData = CimAccess::updateCreditCard($user_data->customer_profile_id,$address,$city,$state,$zip,$user_data->customerPaymentProfileId,$cardNO,$expiryDate,$cvv,$fname,$lname);
			
		}
	
		/*$command = Yii::app()->db->createCommand();
		 $command->update('customer_creditcard_details', array(
		 'name_card'=>$_POST["CustomerCreditCard"]['name_card'],
		 'cardtype'=>$_POST["CustomerCreditCard"]['cardtype'],
		 'cardnumber'=>$_POST["CustomerCreditCard"]['cardnumber'],
		 'csv'=>$_POST["CustomerCreditCard"]['csv'],
		 'expiredate' => $_POST["expiry_year"]."-".$_POST["expiry_month"]
		 ), 'customerid=:id', array(':id'=>$userid));*/
		$this->redirect(array('/users/account'));
	}
	public function actionExportall()
	{
		$userid=Yii::app()->user->getId(); 
		Yii::Import('application.extensions.ExportXLS.ExportXLS');
 
		// Xls Header Row
		$headercolums =array('Service Type','Telephone Number','Status','Ring Type','Destination','Note','Last Update'); 
		$telephone_numbers=Customernumber::model()->findAll("customerid=$userid");	//echo "<pre>";print_r($telephone_number);echo "</pre>";
		// Xls Data
		
		foreach($telephone_numbers as $detail)
		{
			$row=array($detail['type'],$detail['localnumber'],0,$detail['type'],0,0,$detail['starttime']);
			$row1[]=$row;
		}
		 
		// Xls File Name
		$filename = 'telephone_numbers.xls';
		$xls      = new ExportXLS($filename);
		$header = null;
		$xls->addHeader($headercolums);
		$xls->addRow($row1);
		$xls->sendFile();
		$this->redirect(array('customerNumber'));
		/*if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('customernumber/index');
		}else {
			$this->render('customernumber/index');
		}*/
		
	}
	public function actionPayment() {
		$userid=Yii::app()->user->getId(); 
		if(isset($_POST)) {
			 $amount = $_POST["User"]['prepaidamount'];	
		$user_data = InmateUser::model()->find("customerid=$userid"); 
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		if($_POST['payment_type'] == "paypal") {
			

			define( 'SSL_URL', 'https://www.paypal.com/cgi-bin/webscr' );
			 define( 'SSL_SAND_URL', 'https://www.sandbox.paypal.com/cgi-bin/webscr' );
			 $data=array(
			'merchant_email'=>'lmsmerchant@gmail.com',
			'product_name'=>'Demo Product',
			'amount'=>20.50,
			'currency_code'=>'USD',
			'thanks_page'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("site/payByPaypal"),
			'notify_url'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("users/account"),
			'cancel_url'=> "http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("users/account"),
			'paypal_mode'=>true,
			);

			$action = '';
			 //Is this a test transaction?
			 $action = SSL_SAND_URL;

			$form = '';

			$form .= '<form name="frm_payment_method" action="' . $action . '" method="post">';
			 $form .= '<input type="hidden" name="business" value="' . $data['merchant_email'] . '" />';
			 // Instant Payment Notification & Return Page Details /
			 $form .= '<input type="hidden" name="notify_url" value="' . $data['notify_url'] . '" />';
			 $form .= '<input type="hidden" name="cancel_return" value="' . $data['cancel_url'] . '" />';
			 $form .= '<input type="hidden" name="return" value="' . $data['thanks_page'] . '" />';
			 $form .= '<input type="hidden" name="rm" value="2" />';
			 // Configures Basic Checkout Fields -->
			 $form .= '<input type="hidden" name="lc" value="" />';
			 $form .= '<input type="hidden" name="no_shipping" value="1" />';
			 $form .= '<input type="hidden" name="no_note" value="1" />';
			 // <input type="hidden" name="custom" value="localhost" />-->
			 $form .= '<input type="hidden" name="currency_code" value="' . $data['currency_code'] . '" />';
			 $form .= '<input type="hidden" name="page_style" value="paypal" />';
			 $form .= '<input type="hidden" name="charset" value="utf-8" />';
			 $form .= '<input type="hidden" name="item_name" value="' . $data['product_name'] . '" />';
			 $form .= '<input type="hidden" value="_xclick" name="cmd"/>';
			 $form .= '<input type="hidden" name="amount" value="' . $amount . '" />';			 
			 $form .= '<script>';
			 $form .= 'setTimeout("document.frm_payment_method.submit()", 2);';
			 $form .= '</script>';
			 $form .= '</form>';
			 $this->render('payByPaypal',array('form'=>$form));
		}
		if($_POST['payment_type'] == "new_credit_card") {
			 $user_data = InmateUser::model()->find("customerid=$userid"); 
			$name = explode(" ", $_POST["CustomerCreditCard"]['name_card']);
			$fname = $lname = '';
			if(isset($name[0]))
				$fname = $name[0];

			if(isset($name[1]))
				$lname = $name[1];			

			$cardtype = $_POST["CustomerCreditCard"]["cardtype"];		
			

			$cardNO = $_POST["CustomerCreditCard"]['cardnumber'];
		//	$expiryDate =  $_POST["expiry_year"]."-".$_POST["expiry_month"];
			$expiryDate = "2016-02";
			$cvv = $_POST["CustomerCreditCard"]['csv'];	
			if(!empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId))
			{
				CimAccess::authNetDeleteProfile($user_data->customer_profile_id);
				
				$user_data->customer_profile_id = '';
				$user_data->saveAttributes(array('customer_profile_id'));
			}
			if(empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId)) { // save credit card data.				
			//$user_email = $user_data->email;
			$user_email = "t1@g1.com";
			$pno = $user_data->contactnumber;
			$address = $user_data->address1;
			$city = $user_data->city;
			$state = $user_data->state;
			$zip = $user_data->zip;
	
			$creditCardData = CimAccess::saveCreditCard("IU".$userid,$user_email,$address,$city,$state,$zip,$cardNO,$expiryDate,$cvv,$fname,$lname,$pno);
		
			if(!empty($creditCardData)) {
				$command = Yii::app()->db->createCommand();
				$command->update('customer', array(
						'customer_profile_id'=>$creditCardData['profileId'],
					'customerPaymentProfileId'=>$creditCardData['paymentProfileId'],
					'customerAddressId'=>$creditCardData['shippingId']
				), 'customerid=:id', array(':id'=>$userid));
				
			$transactionData = CimAccess::goForTransaction($creditCardData['profileId'],$creditCardData['paymentProfileId'],$creditCardData['shippingId'],$amount);
			}
			}else {
				$address = $user_data->address;
				$city = $user_data->city;
				$state = $user_data->state;
				$zip = $user_data->zip;
				$creditCardData = CimAccess::updateCreditCard($user_data->customer_profile_id,$address,$city,$state,$zip,$user_data->customerPaymentProfileId,$cardNO,$expiryDate,$cvv,$fname,$lname);
				
				$transactionData = CimAccess::goForTransaction($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$user_data->customerAddressId,$amount);

				if( $transactionData['msg'] == "failure") {
				$this->redirect(array('order/failure'));
				}
			}			
			$datetime = date("Y-m-d H:i:s");
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$amount,		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Credit Card",
			'invoicenumber' => $transactionData['transId']
			));
			$newprepaidamount=$user_data->prepaidamount+$amount;
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'prepaidamount'=>$newprepaidamount,			
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('users/account'));
		}
		if($_POST['payment_type'] == "existing_credit_card") {
			
			 $transactionData = CimAccess::goForTransaction($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$user_data->customerAddressId,$amount);						
			if( $transactionData['msg'] == "failure") {
				$this->redirect(array('order/failure'));
			}			
			$datetime = date("Y-m-d H:i:s");
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$amount,		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Credit Card",
			'invoicenumber' => $transactionData['transId']
			));
			$newprepaidamount=$user_data->prepaidamount+$amount;
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'prepaidamount'=>$newprepaidamount,			
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('users/account'));
		}			
			
		
		}else {
		$model = new User;
		$userdetails = Account::model()->find("customerid=$userid");
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('account',array('userdetails'=>$userdetails,'model'=>$model));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'model'=>$model));
		}
	}
	}
	public function actionPayByPaypal() {
		$userid=Yii::app()->user->getId(); 
		$user_data = InmateUser::model()->find("customerid=$userid");
		
		$datetime = date("Y-m-d H:i:s");
		
		if(isset($_REQUEST['amt']) != null && !empty($_REQUEST['amt']))
		{
			$_REQUEST['txn_id'] = $_REQUEST['amt'];
		}
		if(isset($_REQUEST['tx']) != null && !empty($_REQUEST['tx']))
		{
			$_REQUEST['mc_gross'] = $_REQUEST['tx'];
		}
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$_REQUEST['mc_gross'],		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Paypal",
			'invoicenumber' => $_REQUEST['txn_id']
			));
		$newprepaidamount = $user_data->PrepaidAmount + $_REQUEST['mc_gross']; 
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'prepaidamount'=>$newprepaidamount,			
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('users/account'));			
	}
	public function actionBuyMinutes() {
		$userid=Yii::app()->user->getId(); 
		if(isset($_POST)) {
			 $amount = $_POST["minutes_block_price"];	
			 Yii::app()->request->cookies['buy_minutes[extra_minutes]'] = new CHttpCookie('buy_minutes[extra_minutes]', ucfirst($_POST['block']));
		$user_data = InmateUser::model()->find("customerid=$userid"); 
		$gia_block    = "4.00";
		$giatri_block =  $_POST['block'];
		switch ($giatri_block) {
			case 100:
				$so_block = 1;
				break;
		
			case 200:
				$so_block = 2;
				break;
		
			case 300:
				$so_block = 3;
				break;
		
			case 400:
				$so_block = 4;
				break;
			case 500:
				$so_block = 5;
				break;
			case 600:
				$so_block = 6;
				break;
			case 700:
				$so_block = 7;
				break;
			case 800:
				$so_block = 8;
				break;
			case 900:
				$so_block = 9;
				break;
			case 1000:
				$so_block = 10;
				break;
			case 1100:
				$so_block = 11;
				break;
		
			case 1200:
				$so_block = 12;
				break;
		
			case 1300:
				$so_block = 13;
				break;
		
			case 1400:
				$so_block = 14;
				break;
			case 1500:
				$so_block = 15;
				break;
			case 1600:
				$so_block = 16;
				break;
			case 1700:
				$so_block = 17;
				break;
			case 1800:
				$so_block = 18;
				break;
			case 1900:
				$so_block = 19;
				break;
			case 2000:
				$so_block = 20;
				break;
			case 2100:
				$so_block = 21;
				break;
			case 2200:
				$so_block = 22;
				break;
			case 2300:
				$so_block = 23;
				break;
			case 2400:
				$so_block = 24;
				break;
			case 2500:
				$so_block = 25;
				break;
			default:
				$so_block = 0;
		}
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		if($_POST['minutes_payment_type'] == "paypal") {
			

			define( 'SSL_URL', 'https://www.paypal.com/cgi-bin/webscr' );
			 define( 'SSL_SAND_URL', 'https://www.sandbox.paypal.com/cgi-bin/webscr' );
			 $data=array(
			'merchant_email'=>'lmsmerchant@gmail.com',
			'product_name'=>'Demo Product',
			'amount'=>20.50,
			'currency_code'=>'USD',
			'thanks_page'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("site/payForMinutesByPaypal"),
			'notify_url'=>"http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("users/account"),
			'cancel_url'=> "http://".$_SERVER['HTTP_HOST'].Yii::app()->createUrl("users/account"),
			'paypal_mode'=>true,
			);

			$action = '';
			 //Is this a test transaction?
			 $action = SSL_SAND_URL;

			$form = '';

			$form .= '<form name="frm_payment_method" action="' . $action . '" method="post">';
			 $form .= '<input type="hidden" name="business" value="' . $data['merchant_email'] . '" />';
			 // Instant Payment Notification & Return Page Details /
			 $form .= '<input type="hidden" name="notify_url" value="' . $data['notify_url'] . '" />';
			 $form .= '<input type="hidden" name="cancel_return" value="' . $data['cancel_url'] . '" />';
			 $form .= '<input type="hidden" name="return" value="' . $data['thanks_page'] . '" />';
			 $form .= '<input type="hidden" name="rm" value="2" />';
			 // Configures Basic Checkout Fields -->
			 $form .= '<input type="hidden" name="lc" value="" />';
			 $form .= '<input type="hidden" name="no_shipping" value="1" />';
			 $form .= '<input type="hidden" name="no_note" value="1" />';
			 // <input type="hidden" name="custom" value="localhost" />-->
			 $form .= '<input type="hidden" name="currency_code" value="' . $data['currency_code'] . '" />';
			 $form .= '<input type="hidden" name="page_style" value="paypal" />';
			 $form .= '<input type="hidden" name="charset" value="utf-8" />';
			 $form .= '<input type="hidden" name="item_name" value="' . $data['product_name'] . '" />';
			 $form .= '<input type="hidden" value="_xclick" name="cmd"/>';
			 $form .= '<input type="hidden" name="amount" value="' . $amount . '" />';			 
			 $form .= '<script>';
			 $form .= 'setTimeout("document.frm_payment_method.submit()", 2);';
			 $form .= '</script>';
			 $form .= '</form>';
			 $this->render('payByPaypal',array('form'=>$form));
		}
		if($_POST['minutes_payment_type'] == "new_credit_card") {			
			$name = explode(" ", $_POST["CustomerCreditCard1"]['name_card']);
			$fname = $lname = '';
			if(isset($name[0]))
				$fname = $name[0];

			if(isset($name[1]))
				$lname = $name[1];			

			$cardtype = $_POST["CustomerCreditCard1"]["cardtype"];		
			

			$cardNO = $_POST["CustomerCreditCard1"]['cardnumber'];
		//	$expiryDate =  $_POST["expiry_year"]."-".$_POST["expiry_month"];
			$expiryDate = "2016-02";
			$cvv = $_POST["CustomerCreditCard1"]['cvv'];	
			if(empty($user_data->customer_profile_id) && empty($user_data->customerPaymentProfileId)) { // save credit card data.				
			//$user_email = $user_data->email;
			$user_email = "t1@g1.com";
			$pno = $user_data->contactnumber;
			$address = $user_data->address1;
			$creditCardData = CimAccess::saveCreditCard("IU".$userid,$user_email,$cardNO,$expiryDate,$cvv,$fname,$lname,$pno);
			if(!empty($creditCardData)) {
				$command = Yii::app()->db->createCommand();
				$command->update('customer', array(
						'customer_profile_id'=>$creditCardData['profileId'],
					'customerPaymentProfileId'=>$creditCardData['paymentProfileId'],
					'customerAddressId'=>$creditCardData['shippingId']
				), 'customerid=:id', array(':id'=>$userid));
			$transactionData = CimAccess::goForTransaction($creditCardData['profileId'],$creditCardData['paymentProfileId'],$creditCardData['shippingId'],$amount,$giatri_block, $so_block, $gia_block);
			}
			}else {		
				$creditCardData = CimAccess::updateCreditCard($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$cardNO,$expiryDate,$cvv,$fname,$lname);
				
				$transactionData = CimAccess::goForTransaction($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$user_data->customerAddressId,$amount,$giatri_block, $so_block, $gia_block);

				if( $transactionData['msg'] == "failure") {
				$this->redirect(array('order/failure'));
				}
			}
			
			$datetime = date("Y-m-d H:i:s");
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$amount,		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Credit Card",
			'invoicenumber' => $transactionData['transId']
			));
			$total_minutes=$user_data->total_minutes+$_POST['block'];
			$newprepaidamount=$user_data->prepaidamount+$amount;
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'total_minutes'=>$total_minutes,	
			'prepaidamount'=>$newprepaidamount,		
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('users/account'));
		}
		if($_POST['minutes_payment_type'] == "existing_credit_card") {
			
			 $transactionData = CimAccess::goForTransaction($user_data->customer_profile_id,$user_data->customerPaymentProfileId,$user_data->customerAddressId,$amount,$giatri_block, $so_block, $gia_block);						
			if( $transactionData['msg'] == "failure") {
				$this->redirect(array('order/failure'));
			}	
			Yii::log ( CVarDumper::DumpAsString ( $transactionData ), CLogger::LEVEL_WARNING, 'transactionData' );
			Yii::log ( CVarDumper::DumpAsString ( $transactionData['transId'] ), CLogger::LEVEL_WARNING, 'transactionData1' );
			$datetime = date("Y-m-d H:i:s");
			$model = new CustomerPayment();
			$model->customerid = $userid;
			$model->amount = $amount;
			$model->paymentdatetime = $datetime;
			$model->paymentmethod = "Credit Card";
			$model->invoicenumber = $transactionData['transId'];
			$model->save();
		
			
			/* $command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$amount,		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Credit Card",
			'invoicenumber' => $transactionData['transId']
			)); */
			$total_minutes=$user_data->total_minutes+$_POST['block'];
			$newprepaidamount=$user_data->prepaidamount+$amount;
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'total_minutes'=>$total_minutes,			
			'prepaidamount'=>$newprepaidamount,	
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('users/account'));
		}			
			
		
		}else {
		$model = new User;
		$userdetails = Account::model()->find("customerid=$userid");
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('account',array('userdetails'=>$userdetails,'model'=>$model));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'model'=>$model));
		}
	}
	}
	public function actionPayForMinutesByPaypal() { 
		$userid=Yii::app()->user->getId(); 
		$user_data = InmateUser::model()->find("customerid=$userid");
		$datetime = date("Y-m-d H:i:s");
			$command = Yii::app()->db->createCommand();
			$command->insert('customer_payment', array(
			'customerid'=>$userid,	
			'amount'=>$_REQUEST['mc_gross'],		
			'paymentdatetime' => $datetime,
			'paymentmethod' => "Paypal",
			'invoicenumber' => $_REQUEST['txn_id']
			));
		$newprepaidamount = $user_data->prepaidamount + $_REQUEST['mc_gross']; 
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'total_minutes'=>$total_minutes,	
			'prepaidamount'=>$newprepaidamount,			
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('users/account'));			
	}
	public function actionPayment_old()
	{
		$amount = $_POST["User"]["prepaidamount"];
		
		$name_card = $_POST["CustomerCreditCard"]["name_card"];
		$cardtype = $_POST["CustomerCreditCard"]["cardtype"];
		$cardnumber = $_POST["CustomerCreditCard"]["cardnumber"];
		$csv = $_POST["CustomerCreditCard"]["csv"];
		$customer_profile_id=0;
		$customerPaymentProfileId=0;
		$customerAddressId=0;
		
		$userid=Yii::app()->user->getId(); 
		$datas=Dashboard::model()->find("customerid=$userid");		
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		if(empty($datas['customer_profile_id']) && empty($datas['customerPaymentProfileId']) && empty($datas['customerAddressId']))
		{
			//customer roile ID
			$content =
			"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
			"<createCustomerProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
			MerchantAuthenticationBlock().
			"<profile>".
			"<merchantCustomerId>12349</merchantCustomerId>". // Your own identifier for the customer.
			"<description></description>".
			"<email>".$datas['email']."</email>".
			"</profile>".
			"</createCustomerProfileRequest>";
			$response = send_xml_request($content);
			$parsedresponse = parse_api_response($response); print_r($parsedresponse); die("l1");		
			if ("Ok" == $parsedresponse->messages->resultCode) {
				$customer_profile_id= htmlspecialchars($parsedresponse->customerProfileId);
			
				//payment profile ID
				$content =
				"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
				"<createCustomerPaymentProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
				MerchantAuthenticationBlock().
				"<customerProfileId>" .$customer_profile_id. "</customerProfileId>".
				"<paymentProfile>".
				"<billTo>".
				 "<firstName>".$datas['firstname']."</firstName>".
				 "<lastName>".$datas['lastname']."</lastName>".
				 "<phoneNumber>".$datas['contactnumber']."</phoneNumber>".
				"</billTo>".
				"<payment>".
				 "<creditCard>".				 	 
				  "<cardNumber>".$cardnumber."</cardNumber>".
				  "<expirationDate>2020-11</expirationDate>". // required format for API is YYYY-MM
				 "</creditCard>".
				"</payment>".
				"</paymentProfile>".
				"<validationMode>testMode</validationMode>". // or testMode
				"</createCustomerPaymentProfileRequest>";	
				$response = send_xml_request($content);		
				$parsedresponse = parse_api_response($response);
				if ("Ok" == $parsedresponse->messages->resultCode) {
					$customerPaymentProfileId=htmlspecialchars($parsedresponse->customerPaymentProfileId);
				
					//shipping address create
					$content =
					"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
					"<createCustomerShippingAddressRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
					MerchantAuthenticationBlock().
					"<customerProfileId>" .$customer_profile_id. "</customerProfileId>".
					"<address>".
					"<firstName>".$datas['firstname']."</firstName>".
					"<lastName>".$datas['lastname']."</lastName>".
					"<address>".$datas['address1']."</address>".
					"<phoneNumber>".$datas['contactnumber']."</phoneNumber>".
					"</address>".
					"</createCustomerShippingAddressRequest>";
					$response = send_xml_request($content);
					$parsedresponse = parse_api_response($response); print_r($parsedresponse); die("1");
					if ("Ok" == $parsedresponse->messages->resultCode) {
						$customerAddressId=htmlspecialchars($parsedresponse->customerAddressId);
					}
				}
			}
		}
		else
		{
			$customer_profile_id=$datas['customer_profile_id']; 
			$customerPaymentProfileId=$datas['customerPaymentProfileId'];
			$customerAddressId=$datas['customerAddressId'];
		}
		if($customer_profile_id!=0 && $customerPaymentProfileId!=0 && $customerAddressId!=0)
		{
			//create transaction
			$content =
			"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
			"<createCustomerProfileTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
			MerchantAuthenticationBlock().
			"<transaction>".
			"<profileTransAuthOnly>".
			"<amount>" .$amount. "</amount>". // should include tax, shipping, and everything.
			"<shipping>".
			"<amount>0.00</amount>".
			"<name></name>".
			"<description></description>".
			"</shipping>".
			"<lineItems>".
			"<itemId>123456</itemId>".
			"<name>name of item sold</name>".
			"<description>Description of item sold</description>".
			"<quantity>1</quantity>".
			"<unitPrice>" . ($amount - 1.00) . "</unitPrice>".
			"<taxable>false</taxable>".
			"</lineItems>".
			"<lineItems>".
			"<itemId>456789</itemId>".
			"<name>name of item sold</name>".
			"<description>Description of item sold</description>".
			"<quantity>1</quantity>".
			"<unitPrice>1.00</unitPrice>".
			"<taxable>false</taxable>".
			"</lineItems>".
			"<customerProfileId>" .$customer_profile_id. "</customerProfileId>".
			"<customerPaymentProfileId>" .$customerPaymentProfileId. "</customerPaymentProfileId>".
			"<customerShippingAddressId>" .$customerAddressId. "</customerShippingAddressId>".
			"<order>".
			"<invoiceNumber>INV12345</invoiceNumber>".
			"</order>".
			"</profileTransAuthOnly>".
			"</transaction>".
			"</createCustomerProfileTransactionRequest>";
			$response = send_xml_request($content);
			$parsedresponse = parse_api_response($response);print_r($parsedresponse); die("2");
			if ("Ok" == $parsedresponse->messages->resultCode) {
			$directResponseFields = explode(",", $parsedresponse->directResponse);
				$transId = $directResponseFields[6];
			}
			$newprepaidamount=$datas['prepaidamount']+$amount;
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'prepaidamount'=>$newprepaidamount,
			'customer_profile_id'=>$customer_profile_id,
			'customerPaymentProfileId'=>$customerPaymentProfileId,
			'customerAddressId'=>$customerAddressId,
			), 'customerid=:id', array(':id'=>$userid));
			
			$command = Yii::app()->db->createCommand();
			$command->update('customer_creditcard_details', array(
					'name_card'=>$name_card,
				'cardtype'=>$cardtype,
				'cardnumber'=>$cardnumber,
				'csv'=>$csv,
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('site/account'));
			
		}
		
		$model = new User;
		$userdetails = Account::model()->find("customerid=$userid");
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('account',array('userdetails'=>$userdetails,'model'=>$model));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'model'=>$model));
		}
		
	}
	 public function actionHpiCheck()
        {
			if (Yii::app()->request->isAjaxRequest)
            {
				$userid=Yii::app()->user->getId(); 
				$model = new Account($userid);
			 echo "remya";
			}
        }
		
	
	
	
	public function actionBilling()
	{
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('billing');
		}else {
		$this->render('billing');
	}
	}
	
	public function actionTelephonenumbers()
	{
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('telephonenumbers');
		}else {
		$this->render('telephonenumbers');
		}
		
	}
	/**
	 * Displays the login page
	 */
	/*public function actionLogin()
	{
		$model=new LoginForm;

		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}

		// collect user input data
		if(isset($_POST['LoginForm']))
		{
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
				$this->redirect(Yii::app()->user->returnUrl);
		}
		// display the login form
		$this->render('login',array('model'=>$model));
	}*/
	public function actionLogin()
    {
		$this->layout="login-layout";

			if(Yii::app()->user->id) { // check for user session and redirect
				if(Yii::app()->user->role == "payer")
             		$this->redirect(array('users/account'));
             	else
            		 $this->redirect(array('site/dashboard'));
			}
         $model=new LoginForm;

         // if it is ajax validation request
         if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
         {
         	echo CActiveForm::validate($model);
            Yii::app()->end();
         }

                // collect user input data
         if(isset($_POST['LoginForm']))
         {
            $model->attributes=$_POST['LoginForm'];
                        // validate user input and redirect to the previous page if valid
                     
             if($model->validate() && $model->login()){ 
             	Yii::app()->session['payer_userid'] = Yii::app()->user->id;
             
             	if(Yii::app()->user->role == "payer")
             		$this->redirect(array('users/account'));
             	else
            		 $this->redirect(array('site/dashboard'));
         	 }
                                
                        //$this->redirect(Yii::app()->user->returnUrl);
         }
                // display the login form
                $this->render('login',array('model'=>$model));
    }

	public function actionTest() {
		$headers = array (
			'Reply-To: noone@nowhere.lc',
			'X-Mailer: PHP/5.0',
			'MIME-Version: 1.0',
			'Content-type: text/html; charset=iso-8859-1'
		);
		$to = "danilo.santoro@techfusion.it";
		$subject = 'Test Email';
		$message = 'This is a Test Email';
		if(Yii::app()->email->send('register@ylcmail.com', $to, $subject, $message, $headers)) {
			Yii::app()->user->setFlash('success','Your successfully sent an email.');
		} else {
			Yii::app()->user->setFlash('failure','No mail sent!');
		}
	}

	public function actionRegistration() {
		$this->layout="registration-layout";
		$model=new InmateUser();
		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='registration-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		
		if(isset($_POST['InmateUser'])) { 
			$model->attributes = $_POST['InmateUser'];
			
			$password = $model->userpassword; 
			if($model->validate()) {
			
				// save user registration
				if($model->save()) {
					
					 $account_code = sprintf("%05s", $model->customerid);
					$model->account_Code = 'IMS'.$account_code;
					$model->saveAttributes(array('account_Code')); 
					$insert_id = Yii::app()->db->getLastInsertID();
					
					$headers = array (
						'Reply-To: register@ylcmail.com',
						'X-Mailer: PHP/5.0',
						'MIME-Version: 1.0',
						'Content-type: text/html; charset=iso-8859-1'
					);
					$to = $model->email;
					
					$subject = 'Activate your account with yourlocalcall.com';
					$message = '<table width="100%" border="0">
							  <tr>
								<td>Dear '.$model->contactnamefirst." ".$model->contactnamelast.',</td>
							  </tr>
							  <tr>
								<td>&nbsp;</td>
							  </tr>
							  <tr>
								<td>Thanks for signing-up to yourlocalcall.com. You may login using the details below.</td>
							  </tr>
							  <tr>
								<td>&nbsp;</td>
							  </tr>
							  <tr>
								<td>Your account details are:</td>
							  </tr>
							  <tr>
								<td>&nbsp;</td>
							  </tr>
							  <tr>
								<td>Username: '.$model->username.'</td>
							  </tr><tr>
								<td>Password: '.$password.'</td>
							  </tr>
							  <tr>
								<td>&nbsp;</td>
							  </tr>
							  <tr>
								<td>Please click <a href="http://test.yourlocalcall.com/tollx/index.php?r=site/active&id='.$insert_id.'">Activate Account </a>link to activate your account with us.</td>
							  </tr>
							  <tr>
								<td>&nbsp;</td>
							  </tr>
							  <tr>
								<td>Regards,</td>
							  </tr>
							  <tr>
								<td>&nbsp;</td>
							  </tr>
							  <tr>
								<td>yourlocalcall.com Team</td>
							  </tr>
							  <tr>
								<td>yourlocalcall.com</td>
							  </tr>
					</table>';
					if(Yii::app()->email->send('register@ylcmail.com', $to, $subject, $message, $headers)) {
						Yii::app()->user->setFlash('sucess','Your have registered with us successfully. Please check your email for activate your account.');
					} else {
						Yii::app()->user->setFlash('sucess','Your have registered with us successfully.');
					}
				} else {
					Yii::app()->user->setFlash('sucess','Your have not registered with us successfully. Please try again.');
				}

				$this->redirect(Yii::app()->user->returnUrl); // Yii::app()->user->returnUrl
			}
		}
		$countries = Countries::model()->findAll();
		$this->render('registration',array('model'=>$model,'countries' => $countries));  
	}

	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
	
	public function actionActive()
	{
		$this->layout="activate-layout";		
		$model = new User;
	 	$id = Yii::app()->request->getParam('id');
		if(isset($_POST['User']))
		{		
			$model->attributes=$_POST['User'];
			$model = $model->findByAttributes( array('customerid'=>$id) );
			if( $model ){
				$model->status=2;
				$model->save();
				Yii::app()->user->setFlash('sucess','Your account activated successfully.');
				$this->redirect(array('site/login'));
			}
		}
		//reset modell		
		$this->render('activate',array('model'=>$model));
		}

		public function actionVersionCheck() {
			echo "string";
		Yii::app()->email->send('prathapskp@gmail.com', "prathapskp@gmail.com", "test", "test");
		echo Yii::app()->email->getErrors();
	}

	}
