<?php
class InmateUser extends CActiveRecord
{
	public $tos; 
	public $password_repeat;

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'inmate_customers';
	}
	public function rules() { 
		return array(
				array('contactnamefirst, contactnamelast,address,city,state,username,userpassword,password_repeat,email,country', 'required'),
				array ( "address1, firstname,ReferralCustomerID,account_Code,MiddleName,MobileNumber,address2,
				RecurringPayment,RecurringPaymentDate,RecurringPaymentAmount,status,city,state,country,zip,PaymentGatewayId,
				CreatedBy,CreatedDate,UpdatedBy,UpdatedDate,PrepaidAmount,total_minutes,email,username,billemail,skypeid,billstart" , "safe" ) ,
				array('password_repeat', 'compare', 'compareAttribute'=>'userpassword'),
				array('email', 'email','message'=>"The email isn't correct"),
				array('email', 'unique','message'=>"This email already exists"),
				array('username','unique','message'=>"This username already exists"),
		); 
	} 
	public function uniqueUsername($attribute, $params)
	{
		if($user = User::model()->exists('username=:username',array('username'=>$this->username)))
			$this->addError($attribute, 'username already exists!');
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'countrydata'=>array(self::BELONGS_TO, 'Countries', 'country'),
			   'statedata'=>array(self::BELONGS_TO, 'State', 'state'),
			   'customer_number'=>array(self::HAS_MANY, 'CustomerNumber', 'customerId'),
			   'customer_invoice'=>array(self::HAS_MANY, 'CustomernewInvoices', 'customer_id'),
			   'customer_transactions'=>array(self::HAS_MANY, 'Transactions', 'customer_id'),
		);
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Users the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}	
	// hash password
	public function hashPassword($password)
	{
		return md5($password);
	}
			
	// password validation
	public function validatePassword($password)
	{  
		return $this->hashPassword($password)===$this->userpassword;
	}
			
	//generate salt
	/*public function generateSalt()
	{
		return uniqid('',true);
	}
			
	public function beforeValidate()
	{
		$this->salt = $this->generateSalt();
		return parent::beforeValidate();
	}*/
			
	public function beforeSave()
	{
		if ($this->isNewRecord) 
		$this->userpassword = $this->hashPassword($this->userpassword);
		return parent::beforeSave();
	}

}
