<?php

/**
 * This is the model class for table "customer_payment".
 *
 * The followings are the available columns in table 'customer_payment':
 * @property integer $paymentid
 * @property integer $customerid
 * @property string $paymentdatetime
 * @property string $memo
 * @property integer $enteredby
 * @property string $billeddatetime
 * @property string $invoicenumber
 * @property double $amount
 * @property string $paymentmethod
 * @property string $referral
 */
class CustomerPayment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'customer_payment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customerid, enteredby', 'numerical', 'integerOnly'=>true),
			array('amount', 'numerical'),
			array('memo', 'length', 'max'=>8),
			array('invoicenumber', 'length', 'max'=>10),
			array('paymentmethod', 'length', 'max'=>30),
			array('referral', 'length', 'max'=>500),
			array('paymentdatetime, billeddatetime', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('paymentid, customerid, paymentdatetime, memo, enteredby, billeddatetime, invoicenumber, amount, paymentmethod, referral', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'paymentid' => 'Paymentid',
			'customerid' => 'Customerid',
			'paymentdatetime' => 'Paymentdatetime',
			'memo' => 'Memo',
			'enteredby' => 'Enteredby',
			'billeddatetime' => 'Billeddatetime',
			'invoicenumber' => 'Invoicenumber',
			'amount' => 'Amount',
			'paymentmethod' => 'Paymentmethod',
			'referral' => 'Referral',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('paymentid',$this->paymentid);
		$criteria->compare('customerid',$this->customerid);
		$criteria->compare('paymentdatetime',$this->paymentdatetime,true);
		$criteria->compare('memo',$this->memo,true);
		$criteria->compare('enteredby',$this->enteredby);
		$criteria->compare('billeddatetime',$this->billeddatetime,true);
		$criteria->compare('invoicenumber',$this->invoicenumber,true);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('paymentmethod',$this->paymentmethod,true);
		$criteria->compare('referral',$this->referral,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerPayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
