<?php

class SiteController extends Controller
{
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$this->render('index');
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}

	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$name='=?UTF-8?B?'.base64_encode($model->name).'?=';
				$subject='=?UTF-8?B?'.base64_encode($model->subject).'?=';
				$headers="From: $name <{$model->email}>\r\n".
					"Reply-To: {$model->email}\r\n".
					"MIME-Version: 1.0\r\n".
					"Content-Type: text/plain; charset=UTF-8";

				mail(Yii::app()->params['adminEmail'],$subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}
	
	public function actionDashboard()
	{
		$userid=Yii::app()->user->getId(); 
		$model=new Dashboard;
		$criteria=new CDbCriteria;
		$datas=Dashboard::model()->find("customerid=$userid");
		
		$telephone_number=Customernumber::model()->findAll("customerid=$userid");		
		
		 $criteria->condition = 'time BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE() AND customerid='.$userid.'';
		 $cdrs = Cdrs::model()->findAll($criteria);
		 if(Yii::app()->request->isAjaxRequest) {
		 	$this->renderPartial('dashboard',array('data'=>$datas,'telephone_number'=>$telephone_number,'cdrs'=>$cdrs));
			
		}else {
			$this->render('dashboard',array('data'=>$datas,'telephone_number'=>$telephone_number,'cdrs'=>$cdrs));
		}
		
		
	} 
		
	public function actionAccount() {
		$userid=Yii::app()->user->getId(); 
        //$model = User::model()->findByPk($userid);
		$model = new User;		
		$model1= new CustomerCreditCard;
        if (isset($_POST['User'])) { 
			//$model->attributes =$_POST['User'];
			///$model = $model->findByAttributes( array('customerid'=>$userid) );

			//if( $model )
			//{
				//$model->accountcode=2;
				//$model->customerid = $userid;
			//	var_dump($model->isNewRecord);
			//print_r($model);
				$condition = 'customerid ='.$userid;
			    $data['firstname'] = $_POST['User']['firstname'];
			    $data['lastname'] = $_POST['User']['lastname'];
				$model->updateAll( $_POST['User'], $condition );
				//refer: http://harrybailey.com/2011/08/yii-updateall-example/
				//http://www.yiiframework.com/doc/guide/1.1/en/database.ar#updating-record
				//http://stackoverflow.com/questions/20746805/how-does-the-update-operation-work-in-yii
				Yii::app()->user->setFlash('sucess','Your account changed successfully.');				
			//}
        }
		$credit_card_details=array();
		$credit_card_details=CustomerCreditCard::model()->find("customerid=$userid");
		$userdetails = Account::model()->find("customerid=$userid");
		if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('account',array('userdetails'=>$userdetails,'credit_card_details'=>$credit_card_details,'model'=>$model,'model1'=>$model1));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'credit_card_details'=>$credit_card_details,'model'=>$model,'model1'=>$model1));
		}
	}
	public function actionExportall()
	{
		$userid=Yii::app()->user->getId(); 
		Yii::Import('application.extensions.ExportXLS.ExportXLS');
 
		// Xls Header Row
		$headercolums =array('Service Type','Telephone Number','Status','Ring Type','Destination','Note','Last Update'); 
		$telephone_numbers=Customernumber::model()->findAll("customerid=$userid");	//echo "<pre>";print_r($telephone_number);echo "</pre>";
		// Xls Data
		
		foreach($telephone_numbers as $detail)
		{
			$row=array($detail['type'],$detail['localnumber'],0,$detail['type'],0,0,$detail['starttime']);
			$row1[]=$row;
		}
		 
		// Xls File Name
		$filename = 'telephone_numbers.xls';
		$xls      = new ExportXLS($filename);
		$header = null;
		$xls->addHeader($headercolums);
		$xls->addRow($row1);
		$xls->sendFile();
		$this->redirect(array('customerNumber'));
		/*if(Yii::app()->request->isAjaxRequest) {
		$this->renderPartial('customernumber/index');
		}else {
			$this->render('customernumber/index');
		}*/
		
	}

	public function actionPayment()
	{
		$amount = $_POST["User"]["prepaidamount"];
		
		$name_card = $_POST["CustomerCreditCard"]["name_card"];
		$cardtype = $_POST["CustomerCreditCard"]["cardtype"];
		$cardnumber = $_POST["CustomerCreditCard"]["cardnumber"];
		$csv = $_POST["CustomerCreditCard"]["csv"];
		$customer_profile_id=0;
		$customerPaymentProfileId=0;
		$customerAddressId=0;
		
		$userid=Yii::app()->user->getId(); 
		$datas=Dashboard::model()->find("customerid=$userid");		
		require_once Yii::app()->basePath . '/extensions/CIM/util.php';
		if(empty($datas['customer_profile_id']) && empty($datas['customerPaymentProfileId']) && empty($datas['customerAddressId']))
		{
			//customer roile ID
			$content =
			"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
			"<createCustomerProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
			MerchantAuthenticationBlock().
			"<profile>".
			"<merchantCustomerId>12349</merchantCustomerId>". // Your own identifier for the customer.
			"<description></description>".
			"<email>".$datas['email']."</email>".
			"</profile>".
			"</createCustomerProfileRequest>";
			$response = send_xml_request($content);
			$parsedresponse = parse_api_response($response);		
			if ("Ok" == $parsedresponse->messages->resultCode) {
				$customer_profile_id= htmlspecialchars($parsedresponse->customerProfileId);
			
				//payment profile ID
				$content =
				"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
				"<createCustomerPaymentProfileRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
				MerchantAuthenticationBlock().
				"<customerProfileId>" .$customer_profile_id. "</customerProfileId>".
				"<paymentProfile>".
				"<billTo>".
				 "<firstName>".$datas['firstname']."</firstName>".
				 "<lastName>".$datas['lastname']."</lastName>".
				 "<phoneNumber>".$datas['contactnumber']."</phoneNumber>".
				"</billTo>".
				"<payment>".
				 "<creditCard>".				 	 
				  "<cardNumber>".$cardnumber."</cardNumber>".
				  "<expirationDate>2020-11</expirationDate>". // required format for API is YYYY-MM
				 "</creditCard>".
				"</payment>".
				"</paymentProfile>".
				"<validationMode>testMode</validationMode>". // or testMode
				"</createCustomerPaymentProfileRequest>";	
				$response = send_xml_request($content);		
				$parsedresponse = parse_api_response($response);
				if ("Ok" == $parsedresponse->messages->resultCode) {
					$customerPaymentProfileId=htmlspecialchars($parsedresponse->customerPaymentProfileId);
				
					//shipping address create
					$content =
					"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
					"<createCustomerShippingAddressRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
					MerchantAuthenticationBlock().
					"<customerProfileId>" .$customer_profile_id. "</customerProfileId>".
					"<address>".
					"<firstName>".$datas['firstname']."</firstName>".
					"<lastName>".$datas['lastname']."</lastName>".
					"<address>".$datas['address1']."</address>".
					"<phoneNumber>".$datas['contactnumber']."</phoneNumber>".
					"</address>".
					"</createCustomerShippingAddressRequest>";
					$response = send_xml_request($content);
					$parsedresponse = parse_api_response($response);
					if ("Ok" == $parsedresponse->messages->resultCode) {
						$customerAddressId=htmlspecialchars($parsedresponse->customerAddressId);
					}
				}
			}
		}
		else
		{
			$customer_profile_id=$datas['customer_profile_id']; 
			$customerPaymentProfileId=$datas['customerPaymentProfileId'];
			$customerAddressId=$datas['customerAddressId'];
		}
		if($customer_profile_id!=0 && $customerPaymentProfileId!=0 && $customerAddressId!=0)
		{
			//create transaction
			$content =
			"<?xml version=\"1.0\" encoding=\"utf-8\"?>" .
			"<createCustomerProfileTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">" .
			MerchantAuthenticationBlock().
			"<transaction>".
			"<profileTransAuthOnly>".
			"<amount>" .$amount. "</amount>". // should include tax, shipping, and everything.
			"<shipping>".
			"<amount>0.00</amount>".
			"<name></name>".
			"<description></description>".
			"</shipping>".
			"<lineItems>".
			"<itemId>123456</itemId>".
			"<name>name of item sold</name>".
			"<description>Description of item sold</description>".
			"<quantity>1</quantity>".
			"<unitPrice>" . ($amount - 1.00) . "</unitPrice>".
			"<taxable>false</taxable>".
			"</lineItems>".
			"<lineItems>".
			"<itemId>456789</itemId>".
			"<name>name of item sold</name>".
			"<description>Description of item sold</description>".
			"<quantity>1</quantity>".
			"<unitPrice>1.00</unitPrice>".
			"<taxable>false</taxable>".
			"</lineItems>".
			"<customerProfileId>" .$customer_profile_id. "</customerProfileId>".
			"<customerPaymentProfileId>" .$customerPaymentProfileId. "</customerPaymentProfileId>".
			"<customerShippingAddressId>" .$customerAddressId. "</customerShippingAddressId>".
			"<order>".
			"<invoiceNumber>INV12345</invoiceNumber>".
			"</order>".
			"</profileTransAuthOnly>".
			"</transaction>".
			"</createCustomerProfileTransactionRequest>";
			$response = send_xml_request($content);
			$parsedresponse = parse_api_response($response);
			if ("Ok" == $parsedresponse->messages->resultCode) {
			$directResponseFields = explode(",", $parsedresponse->directResponse);
				$transId = $directResponseFields[6];
			}
			$newprepaidamount=$datas['prepaidamount']+$amount;
			$command = Yii::app()->db->createCommand();
			$command->update('customer', array(
			'prepaidamount'=>$newprepaidamount,
			'customer_profile_id'=>$customer_profile_id,
			'customerPaymentProfileId'=>$customerPaymentProfileId,
			'customerAddressId'=>$customerAddressId,
			), 'customerid=:id', array(':id'=>$userid));
			
			$command = Yii::app()->db->createCommand();
			$command->update('customer_creditcard_details', array(
					'name_card'=>$name_card,
				'cardtype'=>$cardtype,
				'cardnumber'=>$cardnumber,
				'csv'=>$csv,
			), 'customerid=:id', array(':id'=>$userid));
			$this->redirect(array('site/account'));
			
		}
		
		$model = new User;
		$userdetails = Account::model()->find("customerid=$userid");
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('account',array('userdetails'=>$userdetails,'model'=>$model));
		}else {
			$this->render('account',array('userdetails'=>$userdetails,'model'=>$model));
		}
		
	}
	 public function actionHpiCheck()
        {
			if (Yii::app()->request->isAjaxRequest)
            {
				$userid=Yii::app()->user->getId(); 
				$model = new Account($userid);
			 echo "remya";
			}
        }
		
	
	
	
	public function actionBilling()
	{
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('billing');
		}else {
		$this->render('billing');
	}
	}
	
	public function actionTelephonenumbers()
	{
		if(Yii::app()->request->isAjaxRequest) {
			$this->renderPartial('telephonenumbers');
		}else {
		$this->render('telephonenumbers');
		}
		
	}
	/**
	 * Displays the login page
	 */
	/*public function actionLogin()
	{
		$model=new LoginForm;

		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}

		// collect user input data
		if(isset($_POST['LoginForm']))
		{
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
				$this->redirect(Yii::app()->user->returnUrl);
		}
		// display the login form
		$this->render('login',array('model'=>$model));
	}*/
	public function actionLogin()
    {
		$this->layout="login-layout";

         $model=new LoginForm;

         // if it is ajax validation request
         if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
         {
         	echo CActiveForm::validate($model);
            Yii::app()->end();
         }

                // collect user input data
         if(isset($_POST['LoginForm']))
         {
            $model->attributes=$_POST['LoginForm'];
                        // validate user input and redirect to the previous page if valid
             if($model->validate() && $model->login()){ 
             $this->redirect(array('site/dashboard'));
         	 }
                                
                        //$this->redirect(Yii::app()->user->returnUrl);
         }
                // display the login form
                $this->render('login',array('model'=>$model));
    }
	public function actionRegistration() 
	{
		$this->layout="registration-layout";
	    $model=new Registration;
	    // if it is ajax validation request
        if(isset($_POST['ajax']) && $_POST['ajax']==='registration-form')
        {
       		echo CActiveForm::validate($model);
          	Yii::app()->end();
        }
		
		if(isset($_POST['Registration']))
        {
			 $model->attributes=$_POST['Registration'];
			 $password=$model->userpassword;
			 if($model->validate())
			 {				
				// save user registration
				if($model->save())
				{
				    $insert_id = Yii::app()->db->getLastInsertID();
					$email = Yii::app()->email;
					$email->to = $model->email;
					$email->subject = 'Activate your account with yourlocalcall.com';
					$email->message = '<table width="100%" border="0">
									  <tr>
										<td>Dear '.$model->firstname." ".$model->lastname.',</td>
									  </tr>
									  <tr>
										<td>&nbsp;</td>
									  </tr>
									  <tr>
										<td>Thanks for signing-up to yourlocalcall.com. You may login using the details below.</td>
									  </tr>
									  <tr>
										<td>&nbsp;</td>
									  </tr>
									  <tr>
										<td>Your account details are:</td>
									  </tr>
									  <tr>
										<td>&nbsp;</td>
									  </tr>
									  <tr>
										<td>Username: '.$model->username.'</td>
									  </tr><tr>
										<td>Password: '.$password.'</td>
									  </tr>
									  <tr>
										<td>&nbsp;</td>
									  </tr>
									  <tr>
										<td>Please click <a href="http://sicsglobal.com/projects/WebT1/etollfree/index.php?r=site/active&id='.$insert_id.'">Activate Account </a>link to activate your account with us.</td>
									  </tr>
									  <tr>
										<td>&nbsp;</td>
									  </tr>
									  <tr>
										<td>Regards,</td>
									  </tr>
									  <tr>
										<td>&nbsp;</td>
									  </tr>
									  <tr>
										<td>yourlocalcall.com Team</td>
									  </tr>
									  <tr>
										<td>yourlocalcall.com</td>
									  </tr>
									</table>';
					if($email->send())
					{
						Yii::app()->user->setFlash('sucess','Your have registered with us successfully. Please check your email for activate your account.');
					}
					else
					{
						Yii::app()->user->setFlash('sucess','Your have not registered with us successfully. Please try again.');
					}
				}
				else
				{
					Yii::app()->user->setFlash('sucess','Your have not registered with us successfully. Please try again.');
				}
				$this->redirect(Yii::app()->user->returnUrl); // Yii::app()->user->returnUrl
			}
		 }
        $this->render('registration',array('model'=>$model));  
    }

	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
	
	public function actionActive()
	{
		$this->layout="activate-layout";		
		$model = new User;
	 	$id = Yii::app()->request->getParam('id');
		if(isset($_POST['User']))
		{		
			$model->attributes=$_POST['User'];
			$model = $model->findByAttributes( array('customerid'=>$id) );
			if( $model ){
				$model->status=2;
				$model->save();
				Yii::app()->user->setFlash('sucess','Your account activated successfully.');
				$this->redirect(array('site/login'));
			}
		}
		//reset modell		
		$this->render('activate',array('model'=>$model));
		}
	}