<?php

/**
 * This is the model class for table "facility_location".
 *
 * The followings are the available columns in table 'facility_location':
 * @property integer $id
 * @property string $facility
 * @property string $phone
 * @property double $inmates
 * @property string $localexchanges
 * @property string $address
 * @property string $citystatezip
 * @property string $f7
 * @property string $timezone
 */
class FacilityLocation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'facility_location';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inmates', 'numerical'),
			array('facility, phone, localexchanges, address, citystatezip, f7, timezone', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, facility, phone, inmates, localexchanges, address, citystatezip, f7, timezone', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'facility' => 'Facility',
			'phone' => 'Phone',
			'inmates' => 'Inmates',
			'localexchanges' => 'Localexchanges',
			'address' => 'Address',
			'citystatezip' => 'Citystatezip',
			'f7' => 'F7',
			'timezone' => 'Timezone',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('facility',$this->facility,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('inmates',$this->inmates);
		$criteria->compare('localexchanges',$this->localexchanges,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('citystatezip',$this->citystatezip,true);
		$criteria->compare('f7',$this->f7,true);
		$criteria->compare('timezone',$this->timezone,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FacilityLocation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
