<?php

/**
 * This is the model class for table "users".
 *
 * The followings are the available columns in table 'users':
 * @property integer $id
 * @property string $username
 * @property string $pwd
 * @property integer $role_id
 * @property string $firstname
 * @property string $lastname
 * @property string $phoneno
 * @property string $email
 * @property string $address1
 * @property string $address2
 * @property integer $zipcode_id
 * @property integer $state_id
 * @property integer $city_id
 * @property integer $country_id
 */
class Users extends CActiveRecord
{
	public $tos; 

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'users';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('role_id, zipcode_id, state_id, city_id, country_id', 'numerical', 'integerOnly'=>true),
			array('username, pwd, firstname, lastname', 'length', 'max'=>55),
			array('phoneno', 'length', 'max'=>15),
			array('address1, address2', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, username, pwd, role_id, firstname, lastname, phoneno, address1, address2, zipcode_id, state_id, city_id, country_id', 'safe', 'on'=>'search'),
			array( 'tos', 'compare', 'on'=>'register', 'compareValue' => true, 'message' => 'You must agree to the terms and conditions' ),

		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => 'Username',
			'pwd' => 'Pwd',
			'role_id' => 'Role',
			'firstname' => 'Firstname',
			'lastname' => 'Lastname',
			'phoneno' => 'Phoneno',
			'email' => 'Email',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'zipcode_id' => 'zipcode_id',
			'state_id' => 'State_id',
			'city_id' => 'City',
			'country_id' => 'Country',
			'tos' => 'I accept Terms and Conditions',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('pwd',$this->pwd,true);
		$criteria->compare('firstname',$this->firstname,true);
		$criteria->compare('lastname',$this->lastname,true);
		$criteria->compare('phoneno',$this->phoneno,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('zipcode_id',$this->zipcode_id);
		$criteria->compare('state_id',$this->state_id);
		$criteria->compare('city_id',$this->city_id);
		$criteria->compare('country_id',$this->country_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Users the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	*** Contry List
	**/

}
